'''
selectcolor.py

編集エリアと結果表示エリアの背景色と文字色を選択するダイアログ
インスタンス作成時にedcol,kkcolで現在の値を渡せる

'''

from tkinter import *
from tkinter import simpledialog as simdlg
from tkinter import colorchooser as colorch

fgini = '#000000'
bgini = '#ffffff'

#戻り値：
# cancel => None
# ok => {'edit':{'fg':color,'bg':color}, 'keka':{'fg':color,'bg':color}}
class selectcolor(simdlg.Dialog):
  #edcol/kkcol:{'fg':color,'bg':color}
  def __init__(self,parent,title=None,edcol=None,kkcol=None):
    self.edfgbg = edcol if edcol else {'fg':fgini,'bg':bgini}
    self.kkfgbg = kkcol if kkcol else {'fg':fgini,'bg':bgini}
    self.setcolorsdic()
    super().__init__(parent,title)

  def body(self,master):
    fr = Frame(self)
    fr.pack(padx=8,pady=5)
    edfr = LabelFrame(fr,text='編集画面')
    edfr.pack(side=LEFT,padx=4)
    self.edtx = Text(edfr,width=22,height=3,fg=self.edfgbg['fg'],
                     bg=self.edfgbg['bg'])
    self.edtx.pack()
    msg = '\n編集画面サンプル'
    self.edtx.insert(END,msg)
    self.edtx['state'] = DISABLED
    bfr = Frame(edfr)
    bfr.pack(anchor=CENTER)
    w = Button(bfr,text='文字色',
           command=lambda:self.getcolor(self.edtx,'ed','fg'))
    w.pack(side=LEFT)
    w = Button(bfr,text='背景色',
           command=lambda:self.getcolor(self.edtx,'ed','bg'))
    w.pack()

    kkfr = LabelFrame(fr,text='結果画面')
    kkfr.pack(padx=4)
    self.kktx = Text(kkfr,width=22,height=3,fg=self.kkfgbg['fg'],
                     bg=self.kkfgbg['bg'])
    self.kktx.pack()
    msg = '\n結果表示画面サンプル'
    self.kktx.insert(END,msg)
    self.kktx['state'] = DISABLED
    bfr = Frame(kkfr)
    bfr.pack(anchor=CENTER)
    w = Button(bfr,text='文字色',
           command=lambda:self.getcolor(self.kktx,'kk','fg'))
    w.pack(side=LEFT)
    w = Button(bfr,text='背景色',
           command=lambda:self.getcolor(self.kktx,'kk','bg'))
    w.pack()

    clearfr = Frame(self)
    clearfr.pack(anchor=CENTER)
    w = Button(clearfr,text='　色設定を初期化します　',
               bg='white',command=self.clear)
    w.pack()

  def clear(self):
    self.edtx['fg'] = fgini
    self.edtx['bg'] = bgini
    self.edfgbg = {'fg':fgini,'bg':bgini}
    self.kktx['fg'] = fgini
    self.kktx['bg'] = bgini
    self.kkfgbg = {'fg':fgini,'bg':bgini}
    
  def setcolorsdic(self):
    self.colors = {'edfg':self.edfgbg['fg'],
                   'edbg':self.edfgbg['bg'],
                   'kkfg':self.kkfgbg['fg'],
                   'kkbg':self.kkfgbg['bg']}
    
  def getcolor(self,w,edkk,fgbg):
    ttl = '編集画面：' if edkk == 'ed' else '結果画面：'
    ttl += '文字色選択' if fgbg=='fg' else '背景色選択'
    col = self.colors[edkk+fgbg]
    res = colorch.askcolor(col,title=ttl,parent=self)
    if not res[1]:
      return
    else:
      dic = self.edfgbg if edkk == 'ed' else self.kkfgbg
      w[fgbg] = dic[fgbg] = res[1]
      self.setcolorsdic()

  def apply(self):
    self.result = {'edit':self.edfgbg,'keka':self.kkfgbg}
    

if __name__=='__main__':
  root = Tk()
  col = selectcolor(root,'文字色、背景色の選択')
  if col.result:
    print('編集画面＝',col.result['edit'],' ','結果画面＝',col.result['keka'])
  else:
    print(col.result)
  root.destroy()
  
  
