#translate_main_pw.py
#
# 結果表示ウィンドウにPanedWindowを利用して原文・訳文のズレを解消
# translate ver 0.8
'''
翻訳支援スクリプトのメインスクリプト

※GAS(Google Apps Script)を活用して個人用の翻訳スクリプトを
　作成していることが前提
      
'''
from tkinter import *
import re,sys,os
from tkinter import messagebox as msgbox
from tkinter import filedialog as fdlg
import pickle
from tkinter import simpledialog as simdlg

#翻訳結果表示用ウィンドウ
from . import panedwin
#GASの翻訳スクリプトURLとの送受信
from . import translate_inc as transl
#tkinterのメニューの簡易ラッパー
from . import menu_inc as mei
#２つ並んだリストボックス
from . import twinlistbox as twin
#スクリプト実行時の設定値(URLなど)の管理
from . import conf_inc as coni
#ディレクトリ・ファイル関係の関数
from . import dirfile_inc as dfi
#スインボックス用のウィンドウ
from . import spinbox_inc as spin
#１行入力用のウィンドウ
from . import inputentry_inc as inp
#表示色選択ダイアログ
from . import selectcolor as selcol

#実行時設定値の保存ファイル名
#メインスクリプトと同じディレクトリにあることが前提
confpath = 'translate.ini'
#表示色既定値
FGcolor = '000000'  #文字色 '#000000'
BGcolor = 'ffffff'  #背景色 '#ffffff'
#バージョン
Version = 'Translate Version: 0.8'
Helpurl = 'https://translate.inblank.net'
Transappurl ='https://translate.inblank.net/gas_translate_app.html'

class main():
  def __init__(self,parent,dispwin=None):
    self.master = parent
    self.dispwin = dispwin
    if dispwin:
      dispwin.mainwin = self  #子から親へのアクセス手段
      dispwin.maintk = self.master  #チップスを親の上に表示するため
    self.filename = ''
    #原文言語初期値
    self.srclangkey = '英語'
    self.srclang = transl.langdic[self.srclangkey]
    #翻訳言語初期値
    self.translangkey = '日本語'
    self.translang = transl.langdic[self.translangkey]
    #翻訳用GAS_scriptのurl
    self.trans_url = ''
    #文字色、背景色
    self.editfg = None  #編集画面　文字色
    self.editbg = None  #編集画面　背景色
    #self.kekafg = None  #結果画面　文字色
    #self.kekabg = None  #結果画面　背景色
    self.setinicolors()   #既定色、ini色設定
    
    self.body()

  def body(self):
    self.btnfr = Frame(self.master)
    self.btnclear = Button(self.btnfr,text='クリア',command=self.boxclear)
    self.btnclear.pack(side=LEFT)
    self.btnpaste = Button(self.btnfr,text='貼付け',command=self.paste)
    self.btnpaste.pack(side=LEFT)
    self.btnedit = Button(self.btnfr,text='編集',command=self.edit)
    self.btnedit.pack(side=LEFT)
    self.btncrclear = Button(self.btnfr,text='改行削除',command=self.crclear)
    self.btncrclear.pack(side=LEFT)
    self.btntranslate = Button(self.btnfr,text='翻訳',command=self.translate)
    self.btntranslate.pack(side=LEFT)
    self.btnadd = Button(self.btnfr,text='追加',command=self.add)
    self.btnadd.pack(side=LEFT)
    self.btninsert = Button(self.btnfr,text='挿入',command=self.insert)
    self.btninsert.pack(side=LEFT)
    self.btnreplace = Button(self.btnfr,text='置換え',command=self.replace)
    self.btnreplace.pack(side=LEFT)
    self.btndelete = Button(self.btnfr,text='削除',command=self.delete)
    self.btndelete.pack(side=LEFT)
    self.btngoto = Button(self.btnfr,text='Goto',command=self.goto)
    self.btngoto.pack(side=LEFT)
    self.entnum = Entry(self.btnfr,width=5)
    self.lblnum = Label(self.btnfr,text='行番号')
    self.entnum.pack(side=RIGHT)
    self.lblnum.pack(side=RIGHT,padx=5)
    self.btnfr.pack()
    
    self.txtfr = Frame(self.master)
    self.lfr = LabelFrame(self.txtfr,relief=FLAT,labelanchor='n')
    self.rfr = LabelFrame(self.txtfr,relief=FLAT,labelanchor='n')
    self.setframelabel()
    
    self.lfr.pack(side=LEFT)
    self.rfr.pack(side=LEFT)
    self.txtfr.pack()
    
    self.lrfrsize()
    self.lfr.propagate(0)
    self.rfr.propagate(0)

    self.ltbox = Text(self.lfr,fg=self.editfg,bg=self.editbg)
    self.rtbox = Text(self.rfr,fg=self.editfg,bg=self.editbg)
    self.ltbox.pack(expand=1,fill=BOTH)
    self.rtbox.pack(expand=1,fill=BOTH)

    #メニュー
    #メニューのラッパー（menu_inc）を使う
    self.menubar = mei.mkmenubar(self.master)
    casclabel = 'F)ファイル'
    commands = [['開く',self.openfile],
                ['上書き保存',self.savefile],
                ['名前を付けて保存',self.savefileas],
                ['',''],
                ['終了',self.endjob]]
    self.filemenu = mei.addcommands(self.menubar,casclabel,
                                    underline=0,commands=commands)
    casclabel = 'テキスト出力'
    commands = [['原文・訳文を同じファイルに',self.sametext],
                ['原文・訳文を別のファイルに',self.sepatext]]
    self.textoutmenu = mei.addcommands(self.filemenu,casclabel,
                                       commands=commands,
                                       insert=3)
    casclabel = 'V)表示'
    commands = [['表示フォントサイズ',self.fontsize],
                ['変換済み：左右入替え',self.lrtxtchg],
                ['表示色変更',self.changecolors]]
    self.viewmenu = mei.addcommands(self.menubar,casclabel,
                                    underline=0,commands=commands)
    casclabel = 'L)言語'
    commands = [['対象言語変更',self.changelang]]
    self.langmenu = mei.addcommands(self.menubar,casclabel,
                                    underline=0,commands=commands)
    casclabel = 'U)URL'
    commands = [['URL編集',self.editurl]]
    self.urlmenu = mei.addcommands(self.menubar,casclabel,
                                    underline=0,commands=commands)
    casclabel = 'H)ヘルプ'
    commands = [['About Translate',self.about],]
    self.helpmenu = mei.addcommands(self.menubar,casclabel,
                                    underline=0,commands=commands)
    #Event関連
    self.bindmaster()
    self.setprotocol()
    
    #ボタン状態管理
    self.master.after(200,self.setbuttonstate)

  # 変換済みテキスト左右入替え
  def lrtxtchg(self):
    self.dispwin.leftright()

  #指定行番号にJUMP
  def goto(self):
    linenumstr = self.entnum.get().strip()
    self.dispwin.goto(linenumstr)
  
  #表示用フォントサイズ
  def fontsize(self):
    #disp側のfontmax,fontmin,fontsizeの設定読み取り
    cursize = int(self.dispwin.fontsize) #str --> int
    maxsize = self.dispwin.fontmax  #int
    minsize = self.dispwin.fontmin  #int
    #spinbox表示
    spbox = spin.spinbox(label='結果表示用フォントサイズ',
                         spmax=maxsize,spmin=minsize,spcur=cursize)
    spbox.master.wait_window(spbox.master)
    #選択値と現在値の比較は.chgfontsize()側で行う
    if spbox.value:
      #disp側のフォントサイズ変更(.chgfontsize())呼び出し
      self.dispwin.chgfontsize(spbox.value)

  #行番号エントリーに値をセットする（主に子から呼ばれる）
  #num: int (not str)
  def setnumentry(self,num=None):
    if num == None:
      return
    self.entnum.delete(0,END)
    self.entnum.insert(0,str(num))
    
  #対象言語変更
  def changelang(self):
    langlist = list(transl.langdic.keys())
    langs = twin.twinlistbox(self.master,llist=langlist,rlist=langlist,
                             llbl='原文言語',rlbl='翻訳言語',
                             title='対象言語の変更')
    if langs.result: #result: [[l_index,item_string],[r_index,item_string]]
      self.srclangkey = langs.result[0][1]
      self.translangkey = langs.result[1][1]
      self.setframelabel()
  
  #原文と訳文の言語をフレームにラベル表示
  def setframelabel(self):
    self.lfr['text'] = '原文：'+self.srclangkey
    self.rfr['text'] = '翻訳：'+self.translangkey
    
  #別々のテキストファイルに出力
  def sepatext(self):
    if not self.dispwin.updatecount()[1]:
      msg = '出力するデータがありません'
      msgbox.showinfo('お知らせ',msg)
      return
    #指定されたファイル名に '__origin', '__trans'を付加する
    fname = fdlg.asksaveasfilename() #.asksaveasfile()ではないので注意
    if not fname:
      return
    splitbase = os.path.splitext(os.path.basename(fname))
    originfname = os.path.dirname(fname) + os.sep + \
                  splitbase[0] + '__origin' + splitbase[1]
    transfname = os.path.dirname(fname) + os.sep + \
                 splitbase[0] +  '__trans' + splitbase[1]
    orfp = open(originfname,mode='w')
    trfp = open(transfname,mode='w')
    datalist = self.dispwin.gettextlistitm()
    for i in datalist:
      orfp.write('{}: {}\n'.format(str(i[0]),i[1]))
      trfp.write('{}: {}\n'.format(str(i[0]),i[2]))
    orfp.close()
    trfp.close()
    msgbox.showinfo('お知らせ','テキストファイルに出力しました')

  #同じテキストファイルに出力
  def sametext(self):
    if not self.dispwin.updatecount()[1]:
      msg = '出力するデータがありません'
      msgbox.showinfo('お知らせ',msg)
      return
    fname = fdlg.asksaveasfilename()
    if not fname:
      return
    datalist = self.dispwin.gettextlistitm()
    origin = '<<__origin__%s>>\n'
    trans = '<<__trans__%s>>\n'
    with open(fname,mode='w') as fp:
      for i in datalist:
        wit = origin % str(i[0]) + i[1] + '\n' + \
              trans % str(i[0]) + i[2] + '\n'
        fp.write(wit)
    msgbox.showinfo('お知らせ','テキストファイルに出力しました')

  #データファイルの保存ディレクトリをiniファイルに保存
  def writelastdir(self,fpath):
    fdata = dfi.getfilestat(fpath)
    item = 'lastdir'
    value = fdata['directory']
    coni.update_item(confpath,item,value)

  #iniファイルからlastdirを読み込んで返す
  def readlastdir(self):
    item = 'lastdir'
    dirdic = coni.read_item(confpath, item)
    if dirdic:
      return dirdic[item]
    else:
      return ''
    
  #データファイルを開く
  def openfile(self):
    #未保存のデータがある場合、破棄してよいか確認する
    if self.dispwin.isupdated():
      msg = '更新されたデータを破棄していいですか？'
      if not msgbox.askokcancel('確認',msg):
        return
    initialdir=self.readlastdir()
    fname = fdlg.askopenfilename(initialdir=initialdir)
    if fname:
      #バイナリで開いてpickleとしてロードしてみる
      with open(fname,mode='rb') as fp:
        fbin = fp.read()
      try:
        textlist = pickle.loads(fbin)
        #textlist : [ [ linenum, text1str, text2str],...]
      except Exception as err:
        msg = 'データファイルから読み込めません'
        msgbox.showerror('エラー',msg)
        return
      #読み込んだデータを復元する
      self.dispwin.restoretextlist(textlist)
      #ファイル名をキープ
      self.filename = fname
      #読み込んだディレクトリをiniに保存
      self.writelastdir(fname)
      

  #保存すべきか否か
  def isneedsave(self):
    #保存すべきデータがあるか
    upcnt = self.dispwin.updatecount()
    if not upcnt[1] or not upcnt[0]:
      msg = 'データの更新がないか、データがありません'
      msgbox.showinfo('保存データなし',msg)
      return False
    else:
      return True
    
  #データをファイルに保存（上書き）する
  def savefile(self,fname=None):
    if not fname:
      #保存すべきデータがあるか
      if not self.isneedsave():
        return
      #既存のデータファイル名がない場合
      if not self.filename:
        #データファイル名を選択
        initialdir = self.readlastdir()
        savefname = fdlg.asksaveasfilename(initialdir=initialdir)
      else:
        savefname = self.filename
    else:
      savefname = fname
    #ファイルに保存
    datalist = self.dispwin.gettextlistitm()
    pickledata = pickle.dumps(datalist)
    try:
      with open(savefname,mode='wb') as fp:
        fp.write(pickledata)
    except Exception as err:
      msg = 'ファイルへの書き込みに失敗しました'
      msgbox.showerror('エラー',msg)
      return
    #ファイル名をキープ
    self.filename = savefname
    #保存できたら更新済みフラグをクリアする
    self.dispwin.clearupdated()
    msgbox.showinfo('お知らせ','ファイルに保存しました')
    #保存ディレクトリをiniに保存
    self.writelastdir(savefname)
    
  #名前を付けてファイルに保存
  def savefileas(self):
    if not self.isneedsave():
      return
    fname = fdlg.asksaveasfilename()
    if not fname:
      return
    self.savefile(fname)
    
  #終了
  def endjob(self):
    self.on_closing()
    
  #翻訳用URLの編集
  def editurl(self):
    if not self.trans_url:
      self.set_trans_url()
    else:
      inpstr = inp.main(title='Google Apps Script URL',
                        msg = '翻訳用GAS_scriptのurlを入力してください',
                        inistr = self.trans_url,
                        leng = 50)
      if not inpstr:
        return
      if inpstr == self.trans_url:
        return
      if self.check_trans_url(inpstr):
        msg = '指定のURLを確認しました'
        msgbox.showinfo(title='Google Apps Script URL',
                        message=msg)
        self.trans_url = inpstr
        #入力されたurlをconfpathに保存
        coni.update_item(confpath,'trans_url',inpstr)
      else:
        msg = '指定されたURLでは正常に送受信できません'
        msgbox.showinfo(title='Google Apps Script URL',
                        message=msg)
        return
  
  #翻訳GAS_scriptのURLをself.trans_urlにセット
  def set_trans_url(self):
    if self.trans_url:
      return True
    else:
      #confpathに登録されているか調べる
      resdic = coni.read_item(confpath,'trans_url')
      if resdic:
        self.trans_url = resdic['trans_url']
        return True
      else:
        #URLを入力
        inpstr = inp.main(title='Google Apps Script URL',
                          msg = '翻訳用GAS_scriptのurlを入力してください',
                          leng = 50)
        if inpstr:
          #urlの真偽チェック
          if self.check_trans_url(inpstr):
            msg = '指定のURLを確認しました'
            msgbox.showinfo(title='Google Apps Script URL',
                            message=msg)
            self.trans_url = inpstr
            #入力されたurlをconfpathに保存
            coni.update_item(confpath,'trans_url',inpstr)
            return True
          else:
            msg = '指定されたURLで正常に送受信できないので翻訳できません'
        else:
          msg = '翻訳用GAS_ScriptのURLが必要です'
        msgbox.showinfo(title='Google Apps Script URL',message=msg)
        return False

  #翻訳GAS_Script URLのチェック
  def check_trans_url(self,url):
    res = transl.get_translated_text(
      url,
      srctext='Test',
      srclang=transl.langdic['英語'],
      tgtlang=transl.langdic['日本語'],
      replcr=False)
    if res:
      if res.strip() == 'テスト':
        return True
      else:
        return False
    else:
      return False

  #文字色、背景色の実行時初期値を設定する
  def setinicolors(self):
    #iniファイルから読み込む iniでは#がコメント扱い
    #設定がなければ初期値をiniファイルに書き込む
    #初期値を設定する
    editfg = coni.read_item(confpath,'editfg')
    editbg = coni.read_item(confpath,'editbg')
    kekafg = coni.read_item(confpath,'kekafg')
    kekabg = coni.read_item(confpath,'kekabg')
    self.editfg = '#'+editfg['editfg'] if editfg else '#'+FGcolor
    self.editbg = '#'+editbg['editbg'] if editbg else '#'+BGcolor
    self.dispwin.kekafg = '#'+kekafg['kekafg'] if kekafg else '#'+FGcolor
    self.dispwin.kekabg = '#'+kekabg['kekabg'] if kekabg else '#'+BGcolor
    #設定がない場合はiniに追加
    if not editfg:
      coni.update_item(confpath,'editfg',FGcolor)
    if not editbg:
      coni.update_item(confpath,'editbg',BGcolor)
    if not kekafg:
      coni.update_item(confpath,'kekafg',FGcolor)
    if not kekafg:
      coni.update_item(confpath,'kekabg',BGcolor)
    #すでに起動している結果表示ウィンドウの背景色を更新する
    self.dispwin.basetwcolor()
    
  #文字色、背景色を変更する
  def changecolors(self):
    res = selcol.selectcolor(self.master,title='文字色・背景色',
                                edcol={'fg':self.editfg,'bg':self.editbg},
                                kkcol={'fg':self.dispwin.kekafg,
                                       'bg':self.dispwin.kekabg})
    if res.result:
      dic = res.result
      #変数更新
      self.editfg = dic['edit']['fg']
      self.editbg = dic['edit']['bg']
      self.dispwin.kekafg = dic['keka']['fg']
      self.dispwin.kekabg = dic['keka']['bg']
      #表示色更新
      self.ltbox['fg'] = self.rtbox['fg'] = self.editfg
      self.ltbox['bg'] = self.rtbox['bg'] = self.editbg
      self.dispwin.basetwcolor()
      self.dispwin.changecolors()
      #ini更新 表示色から#を取り除いて記録
      coni.update_item(confpath,'editfg',self.editfg[1:])
      coni.update_item(confpath,'editbg',self.editbg[1:])
      coni.update_item(confpath,'kekafg',self.dispwin.kekafg[1:])
      coni.update_item(confpath,'kekabg',self.dispwin.kekabg[1:])

  #翻訳
  def translate(self):
    srctext = self.ltbox.get('1.0',END)
    if not self.trans_url:
      if not self.set_trans_url():
        return
    translated = transl.get_translated_text(
      self.trans_url,
      srctext=srctext,
      srclang=transl.langdic[self.srclangkey],
      tgtlang=transl.langdic[self.translangkey],
      replcr=False)
    
    #翻訳結果をrtboxに
    if translated:
      self.rtbox.delete('1.0',END)
      self.rtbox.insert('1.0',translated)
  
  #ボタンの有効無効を一括管理
  def setbuttonstate(self):
    if self.dispwin.closing:
      self.on_closing()
      return
    lt = self.ltbox.get('1.0',END)
    rt = self.rtbox.get('1.0',END)
    if lt.strip():
      self.btncrclear['state'] = NORMAL
    else:
      self.btncrclear['state'] = DISABLED
      
    if (lt.strip() or rt.strip()) and self.entnum.get().strip():
      self.btnreplace['state'] = NORMAL
    else:
      self.btnreplace['state'] = DISABLED

    if lt.strip() or rt.strip():
      self.btnadd['state'] = NORMAL
      self.btnclear['state'] = NORMAL
      if self.entnum.get().strip():
        self.btninsert['state'] = NORMAL
      else:
        self.btninsert['state'] = DISABLED
    else:
      self.btnadd['state'] = DISABLED
      self.btninsert['state'] = DISABLED
      self.btnclear['state'] = DISABLED

    if lt.strip():
      self.btntranslate['state'] = NORMAL
    else:
      self.btntranslate['state'] = DISABLED

    if self.entnum.get().strip():
      smode = NORMAL
    else:
      smode = DISABLED
    self.btndelete['state'] = smode
    self.btnedit['state'] = smode
    self.btngoto['state'] = smode
    
    self.master.after(200,self.setbuttonstate)
    
  #終了処理制御
  def setprotocol(self):
    self.master.protocol('WM_DELETE_WINDOW', self.on_closing)

  def on_closing(self):
    #更新データの保存
    if self.dispwin.isupdated():
      msg = 'データが更新されています。保存しますか？'
      if msgbox.askyesno('未保存データ',msg):
        #保存処理
        self.savefile()
      else:
        msg = '未保存のまま終了します'
        if not msgbox.askokcancel('強制終了',msg):
          return
    if self.dispwin.existwin:
      self.dispwin.master.destroy()
    self.master.destroy()
    #frozen環境でなければ
    if not getattr(sys,'frozen',False):
      print('translate_main >> bye')

  def bindmaster(self):
    self.master.bind('<Configure>',self.prelrfrsize)

  #エントリーが数字のみかどうか
  #戻り値 [True or False,int番号]
  def isdigit(self):
    res = re.search('^([0-9]*)$',self.entnum.get().strip())
    if not res:
      return [False,0]
    else:
      return [True,int(res.group(1))]

  #エントリーに入力された番号を取得して該当するテキストリストの
  #インデックス番号を返す
  #戻り値：[True or False, index]
  def gettextlistindex(self):
    #エントリーに数字以外の入力がないか
    dig = self.isdigit()
    if not dig[0]:
      msgbox.showerror('入力エラー','行番号は半角数字で')
      return [False,'']
    #行番号が存在するかどうか
    idx = self.dispwin.isexistnum(dig[1])  #idx: [True or False, index]
    if not idx[0]:
      msgbox.showerror('入力エラー','指定された番号は存在しません')
      return [False,'']
    else:
      return [True,idx[1]]

  #編集テキストエリアをクリアする
  def boxclear(self):
    self.ltbox.delete('1.0',END)
    self.rtbox.delete('1.0',END)

  #クリップボードのテキストを原文編集エリアに貼り付ける
  def paste(self):
    #クリップボードからデータ取得
    cliptxt = self.master.clipboard_get()
    #テキストの有無確認
    if cliptxt and isinstance(cliptxt,str):
      #self.ltboxにテキストがあれば確認メッセージ
      if self.ltbox.get('1.0',END).strip():
        msg = '現在の編集テキストを破棄していいですか？'
        if msgbox.askokcancel('貼付け',msg):
          self.ltbox.delete('1.0',END)
        else:
          return
      self.ltbox.insert('1.0',cliptxt)

  #既存の行（ブロック）を編集テキストエリアにコピーする
  def edit(self):
    res = self.gettextlistindex()
    if res[0]:
      idx = res[1]
    else:
      return
    lrtxt = self.dispwin.getlrtext(idx)
    if self.ltbox.get('1.0',END).strip() or \
       self.rtbox.get('1.0',END).strip():
      msg = '現在の編集中テキストを破棄していいですか？'
      if msgbox.askokcancel('編集',msg):
        self.ltbox.delete('1.0',END)
        self.rtbox.delete('1.0',END)
      else:
        return
    if not self.dispwin.lrflg:  #反転中なら
      lrtxt[0],lrtxt[1] = lrtxt[1],lrtxt[0]
    self.ltbox.insert('1.0',lrtxt[0])
    self.rtbox.insert('1.0',lrtxt[1])
      

  #原文の編集テキストの改行をスペースで置き換える
  def crclear(self):
    txt = self.ltbox.get('1.0',END).strip()
    txt = txt.replace('\n',' ')
    self.ltbox.delete('1.0',END)
    self.ltbox.insert('1.0',txt)

  #既存の行（ブロック）を編集テキストで置き換える
  def replace(self):
    idx = self.gettextlistindex()
    if not idx[0]:
      return
    msg = '行番号（ブロック）%s番の内容を編集テキストで置換えます' \
          % str(idx[1]+1)
    if msgbox.askokcancel('置換え',msg):
      lt = self.ltbox.get('1.0',END).strip()
      rt = self.rtbox.get('1.0',END).strip()
      if not self.dispwin.lrflg:  #反転中なら
        lt,rt = rt,lt
      self.dispwin.replace(idx[1],lt,rt)
      self.ltbox.delete('1.0',END)
      self.rtbox.delete('1.0',END)

    
  #指定した行番号の前に挿入
  def insert(self):
    idx = self.gettextlistindex()
    if idx[0]:
      msg = '指定された%s番の行（ブロック）の前に挿入します' % str(idx[1]+1)
      if msgbox.askokcancel('挿入確認',msg):
        lt = self.ltbox.get('1.0',END).strip()
        rt = self.rtbox.get('1.0',END).strip()
        if not self.dispwin.lrflg:  #左右反転
          lt,rt = rt,lt
        self.dispwin.insert(idx[1],lt,rt)
        self.ltbox.delete('1.0',END)
        self.rtbox.delete('1.0',END)
        
  #翻訳済みテキスト削除（行（ブロック）単位）
  def delete(self):
    idx = self.gettextlistindex()
    if idx[0]:
      #削除の確認
      msg = '指定された%s番の行（ブロック）を削除します' % str(idx[1]+1)
      if msgbox.askokcancel('削除の確認',msg):
        #テキストリストから削除
        self.dispwin.delete(idx[1])
  
  #翻訳済みテキストを末尾に追加  
  def add(self):
    lt = self.ltbox.get('1.0',END).strip()  #前後の改行は削除
    rt = self.rtbox.get('1.0',END).strip()
    if not self.dispwin.lrflg:  #左右反転してたら
      lt,rt = rt,lt
    #self.dispwin.lrtxt_nor() 編集可否はdispwin側で
    self.dispwin.append(lt,rt)
    #self.dispwin.lrtxt_ro()
    #表示ウィンドウを編集ウィンドウの次にしたい
    #self.dispwin.master.lower(self.master)  #効果なし
    #転送後、編集エリアをクリア
    self.ltbox.delete('1.0',END)
    self.rtbox.delete('1.0',END)

  #サイズ変更イベント処理
  def prelrfrsize(self,ev):
    self.lrfrsize()
    
  #ウィジェットのサイズを返す
  #戻り値：[width,height]
  def getwidgetsize(self,widget):
    widget.update_idletasks()
    res = re.search('([0-9]*?)x([0-9]*?)\+.*',widget.winfo_geometry())
    if res:
      return [int(res.group(1)),int(res.group(2))]
    else:
      self.erroreixt('self.getwidgetsize() error')

  #左右のボックスサイズを揃える
  def lrfrsize(self):
    mastersize = self.getwidgetsize(self.master)
    btnfrsize = self.getwidgetsize(self.btnfr)
    self.lfr['width'] = int(mastersize[0]/2)
    self.rfr['width'] = mastersize[0] - self.lfr['width']
    self.lfr['height'] = self.rfr['height'] = mastersize[1] - btnfrsize[1]

  #About
  def about(self):
    msg = Version + '\n\n'
    msg += 'Google_Apps_Script(GAS)の翻訳機能を利用した翻訳スクリプトです。'
    msg += 'このスクリプトを実行するには、GASで作成したユーザー独自の翻訳Webアプリ'
    msg += 'が必須です。\n\n'
    msg += '※このスクリプトのヘルプ：\n'
    msg += Helpurl+'\n\n'
    msg += '※ユーザー独自の翻訳webアプリの作り方：\n'
    msg += Transappurl
    helpabout(self.master,title='About Translate',msg=msg)
    #msgbox.showinfo('About Translate',msg,parent=self.master)

class helpabout(simdlg.Dialog):
  def __init__(self,parent,title=None,msg=None):
    self.msg = msg
    super().__init__(parent,title)

  def body(self,master):
    Message(self,text=self.msg,width=400).pack()
    
  def buttonbox(self):
    box = Frame(self)
    w = Button(box, text="OK", width=10, command=self.ok, default=ACTIVE)
    w.pack(side=LEFT, padx=5, pady=5)
    self.bind("<Return>", self.ok)
    box.pack()

#コンソール起動のentry_point
def start():
  global confpath
  #iniファイルをこのスクリプトと同じディレクトリに
  #_fstat = dfi.getfilestat(__file__)
  #confpath = dfi.joinpath(_fstat['directory'],confpath)
  confpath = dfi.joinpath(dfi.getscriptdir(),confpath)
  
  #最初に作成したTk()のインスタンスの上にメッセージボックスが
  #表示されるようなのでこの順番でTk()のルートを作成した。
  mainroot = Tk()
  mainroot.geometry('800x300')
  mainroot.title('変換作業エリア')

  #ルートのサイズが未指定の場合panedframe()が期待した動きをしない
  #また、panedframe()内でルートのサイズを変更しても期待どおりには動かない
  pfroot = Tk()
  pfroot.geometry('800x400')
  pfroot['bg'] = 'skyblue'
  pfroot.title('変換済みテキスト')
  pf = panedwin.panedwin(pfroot)
  pf.iamchild = True  #panedwinを外部呼出ししたフラグ

  main(mainroot,dispwin=pf)

  #pfroot.mainloop()
  mainroot.mainloop()
  
#--------------------------------------
if __name__=='__main__':
  start()

##  #iniファイルをこのスクリプトと同じディレクトリに
##  #_fstat = dfi.getfilestat(__file__)
##  #confpath = dfi.joinpath(_fstat['directory'],confpath)
##  confpath = dfi.joinpath(dfi.getscriptdir(),confpath)
##  
##  #最初に作成したTk()のインスタンスの上にメッセージボックスが
##  #表示されるようなのでこの順番でTk()のルートを作成した。
##  mainroot = Tk()
##  mainroot.geometry('800x300')
##  mainroot.title('変換作業エリア')
##
##  #ルートのサイズが未指定の場合panedframe()が期待した動きをしない
##  #また、panedframe()内でルートのサイズを変更しても期待どおりには動かない
##  pfroot = Tk()
##  pfroot.geometry('800x400')
##  pfroot['bg'] = 'skyblue'
##  pfroot.title('変換済みテキスト')
##  pf = panedwin.panedwin(pfroot)
##  pf.iamchild = True  #panedwinを外部呼出ししたフラグ
##
##  main(mainroot,dispwin=pf)
##
##  #pfroot.mainloop()
##  mainroot.mainloop()
