#load_helper.py
'''
データリストと左右のウィンドウ幅（、高さ）を受けて、
フレームに設定すべき高さと左右のテキストを順次返す（イテレータ）。
'''

from tkinter import *

# ltlist:左側のテキストリスト
# rtlist:右側のテキストリスト
# lwd:左側の表示幅
# rwd:右側の表示幅
# fntsize : フォントサイズ（整数文字）
# lrheig:表示高 デフォルト200
# withtext:True 左右のテキストも返す
# 戻り値：withtext=Trueの場合  [全体高,1行高,左テキスト、右テキスト]
#        : withtext=Falseの場合 [全体高,1行高]
class loadhelper(object):
  def __init__(self,ltlist,rtlist,lwd,rwd,fntsize,lrheig=200,withtext=True):
    self.root = Tk()
    #self.root.withdraw()  #非表示ではtextw.count()は機能しない
    self.ltlist = ltlist
    self.rtlist = rtlist
    self.withtext = withtext
    self.fntsize = fntsize
    self._idx = 0
    
    self.body(self.root,lwd,rwd,lrheig,fntsize)

  def __iter__(self):
    return self

  def __next__(self):
    if self._idx == len(self.ltlist):
      self.root.destroy()
      raise StopIteration
    self.ltx.delete('1.0',END)
    self.ltx.insert('1.0',self.ltlist[self._idx])
    self.rtx.delete('1.0',END)
    self.rtx.insert('1.0',self.rtlist[self._idx])

    self.ltx.update_idletasks()
    #テキストウィジェットのサイズより相当大きな領域を必要とする
    #テキストに対しては正常な値を返さない
    lp = self.ltx.count('1.0',END,'ypixels')[0]
    lh = self.ltx.dlineinfo('1.0')[3]
    self.rtx.update_idletasks()
    rp = self.rtx.count('1.0',END,'ypixels')[0]
    rh = self.rtx.dlineinfo('1.0')[3]
    if lp >= rp:
      allp = lp
      ch = lh
    else:
      allp = rp
      ch = rh
    if self.withtext:
      ret = [allp, ch, self.ltlist[self._idx], self.rtlist[self._idx]]
    else:
      ret = [allp, ch]
    self._idx += 1
    return ret
    
  #左右２つのフレームにそれぞれテキストウィジェットを配置
  #テキストウィジェットのサイズはフレーム依存
  def body(self,root,lwd,rwd,lrheig,fntsize):
    root.title('Just a moment...')
    #heightが文量に対して小さすぎると正常な値が得られない
    lfr = Frame(root,width=lwd,height=lrheig)
    lfr.pack_propagate(0)
    rfr = Frame(root,width=rwd,height=lrheig)
    rfr.pack_propagate(0)

    self.ltx = Text(lfr,font=('',fntsize))
    self.ltx.pack(expand=1,fill='both')
    self.rtx = Text(rfr,font=('',fntsize))
    self.rtx.pack(expand=1,fill='both')

    lfr.pack(side=LEFT)
    rfr.pack(side=LEFT)

##  def close(self):
##    self.root.destroy()
##    raise StopIteration()


#-----------------------------------------------
if __name__=='__main__':
  leftset =  ['The tkFileDialog module provides two different pop-up '+
              'windows you can use to give the user the ability to '+
              'find existing files or create new files.',
              '22222222222222222222222222222222']
  rightset = ['333333333333333333333333333333333333333333333333333',
              '44444444444444444']
  lwid = 150
  rwid = 150

  ldhlp = loadhelper(leftset,rightset,lwid,rwid)
  for i in ldhlp:
    print(i)
  

    
